function ARF = Rot(aRF, bRF)
% Generates magnetization operator matrix from Cayley-Klein parameters a and b.
% Input: aRF, bRF = Cayley-Klein parameters a and b respectively.
% 09-January-2003, Yuval Zur.

ARF = zeros(3, 3);
ARF(1, 1) = (conj(aRF))^2; ARF(2, 1) = -(conj(bRF))^2;
ARF(3, 1) = -conj(aRF*bRF);
ARF(1, 2) = -bRF^2; ARF(2, 2) = aRF^2; ARF(3, 2) = -aRF*bRF;
ARF(1, 3) = 2*conj(aRF)*bRF; ARF(2, 3) = 2*aRF*conj(bRF);
ARF(3, 3) = aRF*conj(aRF) - bRF*conj(bRF);
